import requests


class MsgSyncWhatsappAPI:
    def __init__(self, instance_id=None, token=None):
        self.instance_id = instance_id
        self.token = token
        self.url = "https://msgsync.net/api/v1"

    def __add_headers(self, headers={}):
        headers["Instance-id"] = self.instance_id
        headers["Token"] = self.token
        headers["User-Agent"] = "MsgSync API Browser"
        headers["Content-Type"] = "application/x-www-form-urlencoded"
        return headers

    def __execute_request(self, method, path, params=None, data=None, json=None):
        url = f"{self.url}{path}"
        headers = self.__add_headers()
        response = requests.request(method, url, params=params, data=data, json=json, headers=headers)
        return response

    def get_client_class_info(self):
        path = f"/get_client_class_info/"
        return self.__execute_request("POST", path)

    def accept_invite(self, invite_code):
        path = f"/accept_invite"
        data = {"invite_code": invite_code}
        return self.__execute_request("POST", path, data=data)

    def archive_chat(self, chat_id):
        path = f"/archive_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def create_group(self):
        path = f"/create_group/"
        return self.__execute_request("POST", path)

    def get_blocked_contacts(self):
        path = f"/get_blocked_contacts/"
        return self.__execute_request("POST", path)

    def get_chat_by_id(self, chat_id):
        path = f"/get_chat_by_id/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def get_chat_labels(self, chat_id):
        path = f"/get_chat_labels/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def get_chats(self):
        path = f"/get_chats/"
        return self.__execute_request("POST", path)

    def get_groups(self):
        path = f"/get_groups/"
        return self.__execute_request("POST", path)

    def get_chats_by_label_id(self, label_id):
        path = f"/get_chats_by_label_id/"
        data = {"label_id": label_id}
        return self.__execute_request("POST", path, data=data)

    def get_common_groups(self, contact_id):
        path = f"/get_common_groups/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def get_contact_by_id(self, contact_id):
        path = f"/get_contact_by_id/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def get_contacts(self):
        path = f"/get_contacts/"
        return self.__execute_request("POST", path)

    def get_invite_info(self, invite_code):
        path = f"/get_invite_info/"
        data = {"inviteCode": invite_code}
        return self.__execute_request("POST", path, data=data)

    def get_label_by_id(self, label_id):
        path = f"/get_label_by_id/"
        data = {"label_id": label_id}
        return self.__execute_request("POST", path, data=data)

    def get_labels(self):
        path = f"/get_labels/"
        return self.__execute_request("POST", path)

    def get_number_id(self, number):
        path = f"/get_number_id/"
        data = {"number": number}
        return self.__execute_request("POST", path, data=data)

    def is_registered_user(self, number):
        path = f"/is_registered_user/"
        data = {"number": number}
        return self.__execute_request("POST", path, data=data)

    def get_state(self):
        path = f"/get_state/"
        return self.__execute_request("POST", path)

    def mark_chat_unread(self, chat_id):
        path = f"/mark_chat_unread/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def mute_chat(self, chat_id, unmute_date=None):
        path = f"/mute_chat/"
        data = {"chat_id": chat_id, "unmute_date": unmute_date}
        return self.__execute_request("POST", path, data=data)

    def pin_chat(self, chat_id):
        path = f"/pin_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def search_messages(self, query, options=None):
        if options is None:
            options = {}
        path = f"/search_messages/"
        data = {"query": query, "options": options}
        return self.__execute_request("POST", path, data=data)


    def send_text_message(self, chat_id, message):
        path = f"/send_text_message/"
        data = {
            "message": message,
            "chat_id": chat_id
        }
        return self.__execute_request("POST", path, data=data)

    def send_media_message(self, chat_id, mimetype, data, filename):
        path = f"/send_media_message/"
        data = {
            "mimetype": mimetype,
            "data": data,
            "filename": filename,
            "chat_id": chat_id
        }
        return self.__execute_request("POST", path, data=data)

    def send_media_message_from_url(self, chat_id, url, caption=None):
        path = f"/send_media_message_from_url/"
        data = {
            "url": url,
            "chat_id": chat_id,
            "caption": caption
        }
        return self.__execute_request("POST", path, data=data)

    def send_location_message(self, chat_id, latitude, longitude, description=''):
        path = f"/send_location_message/"
        data = {
            "latitude": latitude,
            "longitude": longitude,
            "description": description,
            "chat_id": chat_id
        }
        return self.__execute_request("POST", path, data=data)

    def send_buttons_message(self, chat_id, body, buttons, title, footer):
        path = f"/send_buttons_message/"
        data = {
            "body": body,
            "buttons": buttons,
            "title": title,
            "footer": footer,
            "chat_id": chat_id
        }
        return self.__execute_request("POST", path, data=data)

    def send_list_message(self, chat_id, body, button_text, sections, title, footer):
        path = f"/send_list_message/"
        data = {
            "body": body,
            "buttonText": button_text,
            "sections": sections,
            "title": title,
            "footer": footer,
            "chat_id": chat_id
        }
        return self.__execute_request("POST", path, data=data)

    def send_contact_message(self, chat_id, contact_id):
        path = f"/send_contact_message/"
        data = {
            "contact_id": contact_id,
            "chat_id": chat_id
        }
        return self.__execute_request("POST", path, data=data)

    def send_presence_available(self):
        path = f"/send_presence_available/"
        return self.__execute_request("POST", path)

    def send_presence_unavailable(self):
        path = f"/send_presence_unavailable/"
        return self.__execute_request("POST", path)

    def send_seen(self, chat_id):
        path = f"/send_seen/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def set_display_name(self, display_name):
        path = f"/set_display_name/"
        data = {"displayName": display_name}
        return self.__execute_request("POST", path, data=data)

    def set_profile_picture(self, picture_mimetype, picture_data):
        path = f"/set_profile_picture/"
        data = {"pictureMimetype": picture_mimetype, "pictureData": picture_data}
        return self.__execute_request("POST", path, data=data)

    def set_status(self, status):
        path = f"/set_status/"
        data = {"status": status}
        return self.__execute_request("POST", path, data=data)

    def unarchive_chat(self, chat_id):
        path = f"/unarchive_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def unmute_chat(self, chat_id):
        path = f"/unmute_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def unpin_chat(self, chat_id):
        path = f"/unpin_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def get_wweb_version(self):
        path = f"/get_wweb_version/"
        return self.__execute_request("POST", path)

    def get_class_chat_info(self, chat_id):
        path = f"/get_class_chat_info/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def clear_messages(self, chat_id):
        path = f"/clear_messages/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def clear_state(self, chat_id):
        path = f"/clear_state/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def delete_chat(self, chat_id):
        path = f"/delete_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def fetch_messages(self, chat_id, search_options=None):
        if search_options is None:
            search_options = {}
        path = f"fetch_messages"
        data = {"chat_id": chat_id, "searchOptions": search_options}
        return self.__execute_request("POST", path, data=data)

    def get_contact(self, chat_id):
        path = f"/get_contact/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def send_state_recording(self, chat_id):
        path = f"/send_state_recording/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def send_state_typing(self, chat_id):
        path = f"/send_state_typing/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def get_group_chat_class_info(self, chat_id):
        path = f"/get_group_chat_class_info/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def add_participants_to_group_chat(self, chat_id):
        path = f"/add_participants_to_group_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def demote_participants_in_group_chat(self, chat_id):
        path = f"/demote_participants_in_group_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def get_group_chat_invite_code(self, chat_id):
        path = f"/get_group_chat_invite_code/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def leave_group_chat(self, chat_id):
        path = f"/leave_group_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def promote_participants_in_group_chat(self, chat_id):
        path = f"/promote_participants_in_group_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def remove_participants_from_group_chat(self, chat_id):
        path = f"/remove_participants_from_group_chat/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def revoke_group_chat_invite(self, chat_id):
        path = f"/revoke_group_chat_invite/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def set_group_chat_description(self, chat_id):
        path = f"/set_group_chat_description/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def set_group_chat_info_admins_only(self, chat_id):
        path = f"/set_group_chat_info_admins_only/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def set_group_chat_messages_admins_only(self, chat_id):
        path = f"/set_group_chat_messages_admins_only/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def set_group_chat_subject(self, chat_id):
        path = f"/set_group_chat_subject/"
        data = {"chat_id": chat_id}
        return self.__execute_request("POST", path, data=data)

    def get_class_message_info(self, chat_id, message_id):
        path = f"/get_class_message_info/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def delete_message(self, chat_id, message_id):
        path = f"/delete_message/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def download_media(self, chat_id, message_id):
        path = f"/download_media/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def forward_message(self, chat_id, message_id):
        path = f"/forward_message/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def get_message_info(self, chat_id, message_id):
        path = f"/get_message_info/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def get_quoted_message(self, chat_id, message_id):
        path = f"/get_quoted_message/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def react_to_message(self, chat_id, message_id):
        path = f"/react_to_message/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def reply_to_message(self, chat_id, message_id):
        path = f"/reply_to_message/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def star_message(self, chat_id, message_id):
        path = f"/star_message/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def unstar_message(self, chat_id, message_id):
        path = f"/unstar_message/"
        data = {"chat_id": chat_id, "messageId": message_id}
        return self.__execute_request("POST", path, data=data)

    def get_contact_info(self, contact_id):
        path = f"/get_contact_info/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def block_contact(self, contact_id):
        path = f"/block_contact/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def get_contact_about(self, contact_id):
        path = f"/get_contact_about/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def get_chat_info(self, contact_id):
        path = f"/get_chat_info/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def unblock_contact(self, contact_id):
        path = f"/unblock_contact/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def get_formatted_number(self, contact_id):
        path = f"/get_formatted_number/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def get_country_code(self, contact_id):
        path = f"/get_country_code/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)

    def get_profile_pic_url(self, contact_id):
        path = f"/get_profile_pic_url/"
        data = {"contact_id": contact_id}
        return self.__execute_request("POST", path, data=data)
