<?php

class MsgSyncWhatsappAPI {
    private $instance_id;
    private $token;
    private $url = "https://msgsync.net/api/v1";

    public function __construct($instance_id = null, $token = null) {
        $this->instance_id = $instance_id;
        $this->token = $token;
    }

    private function executeRequest($method, $path, $data = null) {
        $url = $this->url . $path;
        $headers = array(
            "Instance-id: " . $this->instance_id,
            "Token: " . $this->token,
            "User-Agent: MsgSync API Browser",
            "Content-Type: application/x-www-form-urlencoded"
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if ($data) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    public function get_client_class_info() {
        $path = "/get_client_class_info/";
        return $this->executeRequest("POST", $path);
    }

    public function accept_invite($invite_code) {
        $path = "/accept_invite";
        $data = array("invite_code" => $invite_code);
        return $this->executeRequest("POST", $path, $data);
    }

    public function archive_chat($chat_id) {
        $path = "/archive_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function create_group() {
        $path = "/create_group/";
        return $this->executeRequest("POST", $path);
    }

    public function get_blocked_contacts() {
        $path = "/get_blocked_contacts/";
        return $this->executeRequest("POST", $path);
    }

    public function get_chat_by_id($chat_id) {
        $path = "/get_chat_by_id/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_chat_labels($chat_id) {
        $path = "/get_chat_labels/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_chats() {
        $path = "/get_chats/";
        return $this->executeRequest("POST", $path);
    }

    public function get_groups() {
        $path = "/get_groups/";
        return $this->executeRequest("POST", $path);
    }

    public function get_chats_by_label_id($label_id) {
        $path = "/get_chats_by_label_id/";
        $data = array("label_id" => $label_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_common_groups($contact_id) {
        $path = "/get_common_groups/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_contact_by_id($contact_id) {
        $path = "/get_contact_by_id/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_contacts() {
        $path = "/get_contacts/";
        return $this->executeRequest("POST", $path);
    }

    public function get_invite_info($invite_code) {
        $path = "/get_invite_info/";
        $data = array("inviteCode" => $invite_code);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_label_by_id($label_id) {
        $path = "/get_label_by_id/";
        $data = array("label_id" => $label_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_labels() {
        $path = "/get_labels/";
        return $this->executeRequest("POST", $path);
    }

    public function get_number_id($number) {
        $path = "/get_number_id/";
        $data = array("number" => $number);
        return $this->executeRequest("POST", $path, $data);
    }

    public function is_registered_user($number) {
        $path = "/is_registered_user/";
        $data = array("number" => $number);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_state() {
        $path = "/get_state/";
        return $this->executeRequest("POST", $path);
    }

    public function mark_chat_unread($chat_id) {
        $path = "/mark_chat_unread/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function mute_chat($chat_id, $unmute_date = null) {
        $path = "/mute_chat/";
        $data = array("chat_id" => $chat_id, "unmute_date" => $unmute_date);
        return $this->executeRequest("POST", $path, $data);
    }

    public function pin_chat($chat_id) {
        $path = "/pin_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function search_messages($query, $options = null) {
        if ($options === null) {
            $options = array();
        }
        $path = "/search_messages/";
        $data = array("query" => $query, "options" => $options);
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_text_message($chat_id, $message) {
        $path = "/send_text_message/";
        $data = array(
            "message" => $message,
            "chat_id" => $chat_id
        );
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_media_message($chat_id, $mimetype, $data, $filename) {
        $path = "/send_media_message/";
        $data = array(
            "mimetype" => $mimetype,
            "data" => $data,
            "filename" => $filename,
            "chat_id" => $chat_id
        );
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_media_message_from_url($chat_id, $url, $caption=null) {
        $path = "/send_media_message_from_url/";
        $data = array(
            "url" => $url,
            "chat_id" => $chat_id,
            "caption" => $caption
        );
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_location_message($chat_id, $latitude, $longitude, $description = '') {
        $path = "/send_location_message/";
        $data = array(
            "latitude" => $latitude,
            "longitude" => $longitude,
            "description" => $description,
            "chat_id" => $chat_id
        );
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_buttons_message($chat_id, $body, $buttons, $title, $footer) {
        $path = "/send_buttons_message/";
        $data = array(
            "body" => $body,
            "buttons" => $buttons,
            "title" => $title,
            "footer" => $footer,
            "chat_id" => $chat_id
        );
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_list_message($chat_id, $body, $button_text, $sections, $title, $footer) {
        $path = "/send_list_message/";
        $data = array(
            "body" => $body,
            "buttonText" => $button_text,
            "sections" => $sections,
            "title" => $title,
            "footer" => $footer,
            "chat_id" => $chat_id
        );
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_contact_message($chat_id, $contact_id) {
        $path = "/send_contact_message/";
        $data = array(
            "contact_id" => $contact_id,
            "chat_id" => $chat_id
        );
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_presence_available() {
        $path = "/send_presence_available/";
        return $this->executeRequest("POST", $path);
    }

    public function send_presence_unavailable() {
        $path = "/send_presence_unavailable/";
        return $this->executeRequest("POST", $path);
    }

    public function send_seen($chat_id) {
        $path = "/send_seen/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function set_display_name($display_name) {
        $path = "/set_display_name/";
        $data = array("displayName" => $display_name);
        return $this->executeRequest("POST", $path, $data);
    }

    public function set_profile_picture($picture_mimetype, $picture_data) {
        $path = "/set_profile_picture/";
        $data = array("pictureMimetype" => $picture_mimetype, "pictureData" => $picture_data);
        return $this->executeRequest("POST", $path, $data);
    }

    public function set_status($status) {
        $path = "/set_status/";
        $data = array("status" => $status);
        return $this->executeRequest("POST", $path, $data);
    }

    public function unarchive_chat($chat_id) {
        $path = "/unarchive_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function unmute_chat($chat_id) {
        $path = "/unmute_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function unpin_chat($chat_id) {
        $path = "/unpin_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_wweb_version() {
        $path = "/get_wweb_version/";
        return $this->executeRequest("POST", $path);
    }

    public function get_class_chat_info($chat_id) {
        $path = "/get_class_chat_info/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function clear_messages($chat_id) {
        $path = "/clear_messages/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function clear_state($chat_id) {
        $path = "/clear_state/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function delete_chat($chat_id) {
        $path = "/delete_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function fetch_messages($chat_id, $search_options = null) {
        if ($search_options === null) {
            $search_options = array();
        }
        $path = "/fetch_messages";
        $data = array("chat_id" => $chat_id, "searchOptions" => $search_options);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_contact($chat_id) {
        $path = "/get_contact/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_state_recording($chat_id) {
        $path = "/send_state_recording/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function send_state_typing($chat_id) {
        $path = "/send_state_typing/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_group_chat_class_info($chat_id) {
        $path = "/get_group_chat_class_info/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function add_participants_to_group_chat($chat_id) {
        $path = "/add_participants_to_group_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function demote_participants_in_group_chat($chat_id) {
        $path = "/demote_participants_in_group_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_group_chat_invite_code($chat_id) {
        $path = "/get_group_chat_invite_code/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function leave_group_chat($chat_id) {
        $path = "/leave_group_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function promote_participants_in_group_chat($chat_id) {
        $path = "/promote_participants_in_group_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function remove_participants_from_group_chat($chat_id) {
        $path = "/remove_participants_from_group_chat/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function revoke_group_chat_invite($chat_id) {
        $path = "/revoke_group_chat_invite/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function set_group_chat_description($chat_id) {
        $path = "/set_group_chat_description/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function set_group_chat_info_admins_only($chat_id) {
        $path = "/set_group_chat_info_admins_only/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function set_group_chat_messages_admins_only($chat_id) {
        $path = "/set_group_chat_messages_admins_only/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function set_group_chat_subject($chat_id) {
        $path = "/set_group_chat_subject/";
        $data = array("chat_id" => $chat_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_class_message_info($chat_id, $message_id) {
        $path = "/get_class_message_info/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function delete_message($chat_id, $message_id) {
        $path = "/delete_message/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function download_media($chat_id, $message_id) {
        $path = "/download_media/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function forward_message($chat_id, $message_id) {
        $path = "/forward_message/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_message_info($chat_id, $message_id) {
        $path = "/get_message_info/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_quoted_message($chat_id, $message_id) {
        $path = "/get_quoted_message/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function react_to_message($chat_id, $message_id) {
        $path = "/react_to_message/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function reply_to_message($chat_id, $message_id) {
        $path = "/reply_to_message/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function star_message($chat_id, $message_id) {
        $path = "/star_message/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function unstar_message($chat_id, $message_id) {
        $path = "/unstar_message/";
        $data = array("chat_id" => $chat_id, "messageId" => $message_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_contact_info($contact_id) {
        $path = "/get_contact_info/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function block_contact($contact_id) {
        $path = "/block_contact/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_contact_about($contact_id) {
        $path = "/get_contact_about/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_chat_info($contact_id) {
        $path = "/get_chat_info/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function unblock_contact($contact_id) {
        $path = "/unblock_contact/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_formatted_number($contact_id) {
        $path = "/get_formatted_number/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_country_code($contact_id) {
        $path = "/get_country_code/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }

    public function get_profile_pic_url($contact_id) {
        $path = "/get_profile_pic_url/";
        $data = array("contact_id" => $contact_id);
        return $this->executeRequest("POST", $path, $data);
    }
    
}
